#!/bin/sh
#
# by obi

#########
LOGDIR=$(cat /etc/udev/autofs.sh | grep LOGDIR= | cut -d\" -f2)
echo "[umountfs.sh] LOGDIR $LOGDIR"
#########

[ ! -z $LOGDIR ] && [ "$LOGDIR" != "/" ] && [ -e $LOGDIR ] && echo "[umountfs] rm -f $LOGDIR/*" && rm -f $LOGDIR/* && echo "[umountfs] rmdir $LOGDIR" && rmdir $LOGDIR

#########
MOUNTS=$(cat /proc/mounts)
echo "[umountfs.sh] MOUNTS $MOUNTS"

MAPPER=$(fdisk -l | grep /dev/mapper | awk '{ print $2 }' | tr -d ":")
echo "[umountfs.sh] Show active MAPPER start $MAPPER"

[ -e /var/backup ] && echo "[umountfs.sh] remove /var/backup" && rm /var/backup
[ -e /var/swapextensions ] && echo "[umountfs.sh] remove /var/swapextensions" && rm /var/swapextensions

for ROUND in $MAPPER; do
	DEV=$(echo $ROUND | sed 's!/dev/mapper/!!')
	[ ! -z $DEV ] && echo [umountfs] umount /media/*-${DEV}-*
	[ ! -z $DEV ] && umount /media/*-${DEV}-*
	[ ! -z $DEV ] && echo "[umountfs.sh] cryptsetup close $ROUND"
	[ ! -z $DEV ] && cryptsetup close $ROUND
done

MAPPER=$(fdisk -l | grep /dev/mapper | awk '{ print $2 }' | tr -d ":")
echo "[umountfs.sh] Show active MAPPER end $MAPPER"
#########
